﻿// JScript File

/*  function DisplayIt()    ***************************************
*
*   Args:   pMenu   = element to work with
*           bShow   = true/false (meaning show or hide)
*
*   -   pMenu's visibility will be set to visible or hidden based
*       on bShow
*******************************************************************/
function DisplayIt(sId, bShow)
{
    var pLink = document.getElementById(sId);
    var pLinks = document.getElementById(sId.replace("Content", ""));
    
    if (null == pLink)
    {
        return;
    }
    
    if (true == bShow)
    {        
        pLink.style.visibility = "visible";
        pLink.style.display = "block";

        pLinks.className = "LinksClick";
    }
    else
    {    
        pLink.style.visibility = "hidden";
        pLink.style.display = "none";
    }
    
} //function DisplayIt()



/*  function HideAllMenus() ***************************************
*
*   -   Searches all <div> elements for class "MenuPopUp" then,
*       passes the element to DisplayIt(el, false)
*******************************************************************/
function HideAllContent()
{
    var pCollection = document.getElementsByTagName("DIV");
    var pId = null;
    var pLinks = null;
    var Item = 0;
    
    if (pCollection != null)
    {
        for (Item in pCollection)
        {
            if ("LinksContent" == pCollection[Item].className)
            {
                pId = pCollection[Item].id;
                DisplayIt(pId, false);

                pLinks = document.getElementById(pId.replace("Content", ""));
                pLinks.className = "Links";
            }
        }
    }
    
} //function HideAllMenus()

/****************************************************************/
function OnLinksOver(sId)
{
    var pLinks = document.getElementById(sId);
    
    if (pLinks != null)
    {
        if (pLinks.className != "LinksClick")
        {
            pLinks.className = "LinksOver";
        }
    }

} //function OnLinksOver()

/****************************************************************/
function OnLinksOut(sId)
{
    var pLinks = document.getElementById(sId);
    var pLinksContent = document.getElementById(sId + "Content");
    
    if (pLinks != null)
    {
        if (pLinksContent.style.display != "block")
        {
            pLinks.className = "Links";
        }
    }

} //function OnLinksOut()

/****************************************************************/
function OnLinksClick(sId, sImage)
{
    var pLinks = document.getElementById(sId);
    var pImg = document.getElementById("idImg");
    
    if (pLinks != null)
    {
        pLinks.className = "LinksClick";
    }
    
    sId = sId + "Content";
    HideAllContent();             //hide any that are already displayed    
    DisplayIt(sId, true);
    pImg.src = sImage;

} //function OnLinksClick()
